/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.collection.iteration;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.collection.iteration.BitSetIterator;
import icyllis.flexmark.util.collection.iteration.ReversibleIterable;
import icyllis.flexmark.util.collection.iteration.ReversibleIterator;
import java.util.BitSet;

public class BitSetIterable
implements ReversibleIterable<Integer> {
    @NotNull
    private final BitSet bitSet;
    private final boolean reversed;

    public BitSetIterable(@NotNull BitSet bitSet) {
        this(bitSet, false);
    }

    public BitSetIterable(@NotNull BitSet bitSet, boolean reversed) {
        this.bitSet = bitSet;
        this.reversed = reversed;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    @NotNull
    public ReversibleIterator<Integer> iterator() {
        return new BitSetIterator(this.bitSet, this.reversed);
    }

    @Override
    @NotNull
    public ReversibleIterable<Integer> reversed() {
        return new BitSetIterable(this.bitSet, !this.reversed);
    }

    @Override
    @NotNull
    public ReversibleIterator<Integer> reversedIterator() {
        return new BitSetIterator(this.bitSet, !this.reversed);
    }
}

